# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateInstanceByTimeRequest(JDCloudRequest):
    """
    根据日志备份创建一个新的 TiDB 实例
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateInstanceByTimeRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:createInstanceByTime', 'POST', header, version)
        self.parameters = parameters


class CreateInstanceByTimeParameters(object):

    def __init__(self,regionId, instanceId, restoreTime, instanceSpec):
        """
        :param regionId: 地域代码
        :param instanceId: 实例ID
        :param restoreTime: 根据源实例的哪个时间点创建新实例, 北京时间，格式为"YYYY-MM-DD HH:mm:ss"
        :param instanceSpec: 新建实例规格
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.restoreTime = restoreTime
        self.instanceSpec = instanceSpec

