# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class LogpushJob(object):

    def __init__(self, zone_name=None, enabled=None, last_complete=None, logpull_options=None, name=None, error_message=None, destination_conf=None, path=None, service=None, dataset=None, id=None, frequency=None, last_error=None, status=None):
        """
        :param zone_name: (Optional) 域名
        :param enabled: (Optional) 
        :param last_complete: (Optional) 记录上次成功推送日志的时间。如果上次成功推送的日志范围为2018-07-23T10:00:00Z至2018-07-23T10:01:00Z，则该字段的值将为2018-07-23T10:01:00Z。如果作业从未运行或刚刚启用但尚未运行，则该字段将为空。
        :param logpull_options: (Optional) 它指定了诸如请求的字段和时间戳格式之类的内容。
        :param name: (Optional) 可选的用户可读的作业名称。不是独一无二的。使用户更容易识别工作。建议包含域名称。
        :param error_message: (Optional) 如果不为null，则表示作业当前失败。失败通常是重复的（例如：没有写入目标存储桶的权限）。只记录最后一次故障。成功执行作业时，错误消息和最后一个错误被设置为null。
        :param destination_conf: (Optional) 唯一标识数据推送目的地的字符串。可能包括目的地支持的其他参数。
        :param path: (Optional) 唯一标识数据推送目的地的字符串。
        :param service: (Optional) 服务名称，例如Amazon S3, Splunk。
        :param dataset: (Optional) 要推送的数据集。
        :param id: (Optional) 作业的唯一id。
        :param frequency: (Optional) 星盾向目标发送成批日志的频率。将“频率”设置为“高”会将日志发送到更多更小的文件中。将“频率”设置为“低”会以较小数量的较大文件发送日志。
        :param last_error: (Optional) 记录上次作业失败的时间。如果不为null，则表示作业当前失败。如果为null，则表示作业从未失败，或者自上次失败以来至少成功运行过一次。另请参见错误消息字段。
        :param status: (Optional) 推送状态，合法值：Pushing-正在推送，Error-推送失败，Off-关闭
        """

        self.zone_name = zone_name
        self.enabled = enabled
        self.last_complete = last_complete
        self.logpull_options = logpull_options
        self.name = name
        self.error_message = error_message
        self.destination_conf = destination_conf
        self.path = path
        self.service = service
        self.dataset = dataset
        self.id = id
        self.frequency = frequency
        self.last_error = last_error
        self.status = status
