# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class OrderAdvancedCertificateManagerCertificatePackRequest(JDCloudRequest):
    """
    对于一个特定域，订购一个高级证书包
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(OrderAdvancedCertificateManagerCertificatePackRequest, self).__init__(
            '/zones/{zone_identifier}/ssl$$certificate_packs$$order', 'POST', header, version)
        self.parameters = parameters


class OrderAdvancedCertificateManagerCertificatePackParameters(object):

    def __init__(self,zone_identifier, ):
        """
        :param zone_identifier: 
        """

        self.zone_identifier = zone_identifier
        self.ty_pe = None
        self.hosts = None
        self.validation_method = None
        self.validity_days = None
        self.certificate_authority = None
        self.cloudflare_branding = None

    def setTy_pe(self, ty_pe):
        """
        :param ty_pe: (Optional) 证书包的类型
        """
        self.ty_pe = ty_pe

    def setHosts(self, hosts):
        """
        :param hosts: (Optional) 以逗号分隔的证书包的有效主机名称列表。必须包含域的顶级域名，不得包含50个以上的主机，也不得为空。
        """
        self.hosts = hosts

    def setValidation_method(self, validation_method):
        """
        :param validation_method: (Optional) 为订阅选择的验证方法
        """
        self.validation_method = validation_method

    def setValidity_days(self, validity_days):
        """
        :param validity_days: (Optional) 为订阅选择的有效日期
        """
        self.validity_days = validity_days

    def setCertificate_authority(self, certificate_authority):
        """
        :param certificate_authority: (Optional) 为该订阅选择的证书颁发机构。选择Let's Encrypt将减少对其他字段的定制。
validation_method必须是'txt'，validity_days必须是90，cloudflare_branding必须省略，hosts必须只包含两个条目。
一个是域名，一个是域名的子域通配符（例如 example.com, *.example.com）。

        """
        self.certificate_authority = certificate_authority

    def setCloudflare_branding(self, cloudflare_branding):
        """
        :param cloudflare_branding: (Optional) 是否为订阅添加星盾品牌。
        """
        self.cloudflare_branding = cloudflare_branding

