# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ClusterSpec(object):

    def __init__(self, name, azs, masterCIDR, accessKey, secretKey, description=None, basicAuth=None, clientCertificate=None, version=None, nodeGroup=None):
        """
        :param name:  名称（同一用户的 cluster 允许重名）
        :param description: (Optional) 描述
        :param basicAuth: (Optional) 默认开启 basicAuth与clientCertificate最少选择一个
        :param clientCertificate: (Optional) 默认开启 basicAuth与clientCertificate最少选择一个
        :param version: (Optional) kubernetes的版本,默认1.8
        :param azs:  集群所在的az
        :param nodeGroup: (Optional) 实例组
        :param masterCIDR:  k8s的master的cidr
        :param accessKey:  用户的AccessKey，插件调用open-api时的认证凭证
        :param secretKey:  用户的SecretKey，插件调用open-api时的认证凭证
        """

        self.name = name
        self.description = description
        self.basicAuth = basicAuth
        self.clientCertificate = clientCertificate
        self.version = version
        self.azs = azs
        self.nodeGroup = nodeGroup
        self.masterCIDR = masterCIDR
        self.accessKey = accessKey
        self.secretKey = secretKey
