# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeMetricDataRequest(JDCloudRequest):
    """
    查看某资源单个监控项数据
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeMetricDataRequest, self).__init__(
            '/idcs/{idc}/metrics/{metric}/metricData', 'GET', header, version)
        self.parameters = parameters


class DescribeMetricDataParameters(object):

    def __init__(self, idc,metric,resourceId, startTime, endTime, ):
        """
        :param idc: IDC机房ID
        :param metric: 监控项英文标识(id)
        :param resourceId: 资源ID
        :param startTime: 查询时间范围的开始时间， UNIX时间戳，（机柜电流最多支持最近90天数据查询、带宽流量最多支持最近30天数据查询）
        :param endTime: 查询时间范围的结束时间， UNIX时间戳，（机柜电流最多支持最近90天数据查询、带宽流量最多支持最近30天数据查询）
        """

        self.idc = idc
        self.metric = metric
        self.resourceId = resourceId
        self.startTime = startTime
        self.endTime = endTime
        self.timeInterval = None
        self.ip = None
        self.port = None

    def setTimeInterval(self, timeInterval):
        """
        :param timeInterval: (Optional) 时间间隔：分钟m、小时h、天d，如： 10分钟=10m、1小时=1h，3天=3d；默认5m，最小支持5m，最大90d 目前带宽上、下行流量查询，时间间隔：1m、5m，默认5m。1m时间间隔支持的最大时间范围为2小时
        """
        self.timeInterval = timeInterval

    def setIp(self, ip):
        """
        :param ip: (Optional) 交换机IP，指定ip时须同时指定port
        """
        self.ip = ip

    def setPort(self, port):
        """
        :param port: (Optional) 端口，指定port时须同时指定ip
        """
        self.port = port

