# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class InvokeThingServiceRequest(JDCloudRequest):
    """
    设备服务调用
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(InvokeThingServiceRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/products/{productKey}/devices/{identifier}/services', 'POST', header, version)
        self.parameters = parameters


class InvokeThingServiceParameters(object):

    def __init__(self, instanceId, regionId, identifier, productKey, name, ):
        """
        :param instanceId: 设备归属的实例ID
        :param regionId: 设备归属的实例所在区域
        :param identifier: 设备唯一标识
        :param productKey: 产品Key
        :param name: 服务名称
        """

        self.instanceId = instanceId
        self.regionId = regionId
        self.identifier = identifier
        self.productKey = productKey
        self.name = name
        self.input = None
        self.callbackBeanName = None

    def setInput(self, input):
        """
        :param input: (Optional) 输入参数,object的key为参数名称，value为参数值
        """
        self.input = input

    def setCallbackBeanName(self, callbackBeanName):
        """
        :param callbackBeanName: (Optional) 回调spring的bean的名称
        """
        self.callbackBeanName = callbackBeanName

