# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CollectorWriteMessageRequest(JDCloudRequest):
    """
    写入采集器数据
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(CollectorWriteMessageRequest, self).__init__(
            '/regions/{regionId}/loongrayinstances/{instanceId}/writeCollectorProperty', 'POST', header, version)
        self.parameters = parameters


class CollectorWriteMessageParameters(object):

    def __init__(self, instanceId, regionId, identifier, data):
        """
        :param instanceId: Hub实例Id
        :param regionId: 区域Id
        :param identifier: 当前的链接码
        :param data: 当前待写入的数据
如语音播报控制器-指定播放设备，寄存地址：13对应16进制0x0D，寄存器值:2
{
  "13":2
}
如语音播报控制器-播放控制，寄存地址：14对应16进制0x0E，寄存器值:1
{
  "14": 1
}
如语音播报控制器-音量设置，寄存地址：15对应16进制0x0F，寄存器值:10，取值范围0~30
{
  "15": 10
}
如语音播报控制器-指定文件夹和文件播放,寄存地址：16对应16进制0x10，寄存器值:1
寄存器值为两字节，第一个字节为文件夹，第二个字节为文件名
如0x01文件夹,0x03文件名，0x0103换算为10进制为259
{
  "16": 259
}
如语音播报控制器-组合播放，寄存器地址：17、18和19，寄存器值：257、258和259，寄存器值的算法和指定文件夹和文件播放是一致的，如259可换算为0x01文件夹,0x03文件名
{
  "17": 257,
  "18": 258,
  "19": 259
}
如语音播报控制器-播放广告，寄存地址：32对应16进制0x20，寄存器值:259，寄存器值的算法和指定文件夹和文件播放是一致的，如259可换算为0x01文件夹,0x03文件名
{
  "32": 259
}
如语音播报控制器-指定文件夹循环播放，寄存地址：33对应16进制0x21，寄存器值:256，寄存器值的算法，如256可换算为0x0100文件夹
{
  "33": 256
}
如语音播报控制器-指定文件夹随机播放，寄存地址：34对应16进制0x22，寄存器值:256，寄存器值的算法，如256可换算为0x0100文件夹
{
  "34": 256
}
如语音播报控制器-指定曲目播放，寄存地址：35对应16进制0x23，寄存器值:13,歌曲选择范围为0~3000
{
  "35": 13
}
如电梯数据采集器-传感器管理数据更新
{
  "40426": 1,
  "40427": 1,
  "40428": 1,
  "40429": 1,
  "40430": 1,
  "40431": 1,
  "40432": 1,
  "40433": 1,
  "40434": 1,
  "40435": 1,
  "40436": 1,
  "40437": 1,
  "40438": 1,
  "40439": 1,
  "40440": 1
}
如电梯数据采集器-采集器属性数据更新
{
  "40441": 40441,
  "40443": 40443,
  "40444": 40444,
  "40445": 40445,
  "40446": 40446,
  "40447": 40447,
  "40448": 40448,
  "40449": 40449,
  "40450": 40450
}
如电梯数据采集器-电梯属性数据更新
{
  "40801": 1,
  "40802": 1,
  "40803": 1,
  "40804": 1,
  "40805": 1,
  "40806": 1,
  "40807": 1,
  "40808": 1,
  "40809": 1,
  "40810": 1
}
如电梯数据采集器-楼层数据更新
{
  "40797": 1,
  "40798": 1,
  "40799": 1
}

        """

        self.instanceId = instanceId
        self.regionId = regionId
        self.identifier = identifier
        self.protocol = None
        self.data = data

    def setProtocol(self, protocol):
        """
        :param protocol: (Optional) 当前的协议类型,非必填项

        """
        self.protocol = protocol

