# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyInstanceSpecRequest(JDCloudRequest):
    """
    变更es实例的配置，实例为running状态才可变更配置，每次只能变更一种且不可与原来的相同。
实例配置（cpu核数、内存、磁盘容量、节点数量）目前只允许变大

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyInstanceSpecRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyInstanceSpec', 'POST', header, version)
        self.parameters = parameters


class ModifyInstanceSpecParameters(object):

    def __init__(self, regionId, instanceId, ):
        """
        :param regionId: regionId
        :param instanceId: 实例ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.nodeClass = None
        self.nodeDiskGB = None
        self.nodeCount = None
        self.masterClass = None
        self.coordinatingClass = None
        self.coordinatingCount = None

    def setNodeClass(self, nodeClass):
        """
        :param nodeClass: (Optional) data节点规格
        """
        self.nodeClass = nodeClass

    def setNodeDiskGB(self, nodeDiskGB):
        """
        :param nodeDiskGB: (Optional) data节点磁盘
        """
        self.nodeDiskGB = nodeDiskGB

    def setNodeCount(self, nodeCount):
        """
        :param nodeCount: (Optional) data节点数
        """
        self.nodeCount = nodeCount

    def setMasterClass(self, masterClass):
        """
        :param masterClass: (Optional) master节点规格
        """
        self.masterClass = masterClass

    def setCoordinatingClass(self, coordinatingClass):
        """
        :param coordinatingClass: (Optional) coordinating节点规格
        """
        self.coordinatingClass = coordinatingClass

    def setCoordinatingCount(self, coordinatingCount):
        """
        :param coordinatingCount: (Optional) coordinating节点数
        """
        self.coordinatingCount = coordinatingCount

