# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GeneralCreateFunctionRequest(JDCloudRequest):
    """
    生产创建函数过程SQL语句，支持Mysql
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GeneralCreateFunctionRequest, self).__init__(
            '/regions/{regionId}/function:generalCreate', 'POST', header, version)
        self.parameters = parameters


class GeneralCreateFunctionParameters(object):

    def __init__(self,regionId, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        """

        self.regionId = regionId
        self.dataSourceId = None
        self.dbName = None
        self.functionName = None
        self.functionSecurity = None
        self.dataAccess = None
        self.deterministic = None
        self.definitionSql = None
        self.parameters = None
        self.definer = None
        self.comment = None
        self.returnType = None
        self.returnLength = None

    def setDataSourceId(self, dataSourceId):
        """
        :param dataSourceId: (Optional) 数据源id。
        """
        self.dataSourceId = dataSourceId

    def setDbName(self, dbName):
        """
        :param dbName: (Optional) 数据库名称。
        """
        self.dbName = dbName

    def setFunctionName(self, functionName):
        """
        :param functionName: (Optional) 函数名称。
        """
        self.functionName = functionName

    def setFunctionSecurity(self, functionSecurity):
        """
        :param functionSecurity: (Optional) 安全性，DEFAULT("DEFAULT", 1),DEFINER("DEFINER", 2), INVOKER("INVOKER", 3);
        """
        self.functionSecurity = functionSecurity

    def setDataAccess(self, dataAccess):
        """
        :param dataAccess: (Optional) 数据访问，DEFAULT("DEFAULT", 1),NO_SQL("NO_SQL", 2), CONTAINS_SQL("CONTAINS_SQL", 3), READS_SQL_DATA("READS_SQL_DATA", 4), MODIFIES_SQL_DATA("MODIFIES_SQL_DATA", 5);
        """
        self.dataAccess = dataAccess

    def setDeterministic(self, deterministic):
        """
        :param deterministic: (Optional) 确定性。
        """
        self.deterministic = deterministic

    def setDefinitionSql(self, definitionSql):
        """
        :param definitionSql: (Optional) 函数定义SQL。
        """
        self.definitionSql = definitionSql

    def setParameters(self, parameters):
        """
        :param parameters: (Optional) 参数列表。
        """
        self.parameters = parameters

    def setDefiner(self, definer):
        """
        :param definer: (Optional) 定义者。
        """
        self.definer = definer

    def setComment(self, comment):
        """
        :param comment: (Optional) 注释。
        """
        self.comment = comment

    def setReturnType(self, returnType):
        """
        :param returnType: (Optional) 返回值类型，TINYINT("TINYINT", 0), SMALLINT("SMALLINT", 1), MEDIUMINT("MEDIUMINT", 2), INT("INT", 3), BIGINT("BIGINT", 4), INTEGER("INTEGER", 5), FLOAT("FLOAT", 6), DOUBLE("DOUBLE", 7), REAL("REAL", 8), DECIMAL("DECIMAL", 9), CHAR("CHAR", 10), VARCHAR("VARCHAR", 11), TINYTEXT("TINYTEXT", 12), TEXT("TEXT", 13), MEDIUMTEXT("MEDIUMTEXT", 14), LONGTEXT("LONGTEXT", 15), DATE("DATE", 16), DATETIME("DATETIME", 17), TIMESTAMP("TIMESTAMP", 18), TIME("TIME", 19), YEAR("YEAR", 19), BINARY("BINARY", 20), VARBINARY("VARBINARY", 21), TINYBLOB("TINYBLOB", 22), BLOB("BLOB", 23), MEDIUMBLOB("MEDIUMBLOB", 24), LONGBLOB("LONGBLOB", 25);
        """
        self.returnType = returnType

    def setReturnLength(self, returnLength):
        """
        :param returnLength: (Optional) 返回值长度。
        """
        self.returnLength = returnLength

