# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GeneralAlterProcedureRequest(JDCloudRequest):
    """
    生成修改存储过程sql语句，支持Mysql
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GeneralAlterProcedureRequest, self).__init__(
            '/regions/{regionId}/procedure:generalAlter', 'POST', header, version)
        self.parameters = parameters


class GeneralAlterProcedureParameters(object):

    def __init__(self,regionId, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        """

        self.regionId = regionId
        self.dataSourceId = None
        self.dbName = None
        self.originProcedureName = None
        self.procedureName = None
        self.definer = None
        self.procedureSecurity = None
        self.dataAccess = None
        self.deterministic = None
        self.definitionSql = None
        self.completeSql = None
        self.parameters = None
        self.comment = None

    def setDataSourceId(self, dataSourceId):
        """
        :param dataSourceId: (Optional) 数据源id
        """
        self.dataSourceId = dataSourceId

    def setDbName(self, dbName):
        """
        :param dbName: (Optional) 数据库名称。
        """
        self.dbName = dbName

    def setOriginProcedureName(self, originProcedureName):
        """
        :param originProcedureName: (Optional) 原存储过程名称。
        """
        self.originProcedureName = originProcedureName

    def setProcedureName(self, procedureName):
        """
        :param procedureName: (Optional) 存储过程名称。
        """
        self.procedureName = procedureName

    def setDefiner(self, definer):
        """
        :param definer: (Optional) 定义者。
        """
        self.definer = definer

    def setProcedureSecurity(self, procedureSecurity):
        """
        :param procedureSecurity: (Optional) 安全性，DEFAULT("DEFAULT", 1),DEFINER("DEFINER", 2), INVOKER("INVOKER", 3);
        """
        self.procedureSecurity = procedureSecurity

    def setDataAccess(self, dataAccess):
        """
        :param dataAccess: (Optional) 数据访问，DEFAULT("DEFAULT", 1),NO_SQL("NO_SQL", 2), CONTAINS_SQL("CONTAINS_SQL", 3), READS_SQL_DATA("READS_SQL_DATA", 4), MODIFIES_SQL_DATA("MODIFIES_SQL_DATA", 5);
        """
        self.dataAccess = dataAccess

    def setDeterministic(self, deterministic):
        """
        :param deterministic: (Optional) 确定性。
        """
        self.deterministic = deterministic

    def setDefinitionSql(self, definitionSql):
        """
        :param definitionSql: (Optional) 存储过程定义SQL。
        """
        self.definitionSql = definitionSql

    def setCompleteSql(self, completeSql):
        """
        :param completeSql: (Optional) 创建存储过程定义完整SQL。
        """
        self.completeSql = completeSql

    def setParameters(self, parameters):
        """
        :param parameters: (Optional) 参数列表。
        """
        self.parameters = parameters

    def setComment(self, comment):
        """
        :param comment: (Optional) 注释
        """
        self.comment = comment

