# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeReportListRequest(JDCloudRequest):
    """
    获取任务下的报表列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeReportListRequest, self).__init__(
            '/regions/{regionId}/tasks/{taskId}', 'GET', header, version)
        self.parameters = parameters


class DescribeReportListParameters(object):

    def __init__(self, regionId, taskId, instanceId):
        """
        :param regionId: 地域 Id
        :param taskId: 任务ID
        :param instanceId: 实例ID
        """

        self.regionId = regionId
        self.taskId = taskId
        self.pageNumber = None
        self.pageSize = None
        self.instanceId = instanceId

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码；默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小；默认为10；取值范围[10, 100]
        """
        self.pageSize = pageSize

