# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeElasticIpResourcesRequest(JDCloudRequest):
    """
    查询基础防护已防护的私有网络的弹性公网 IP 的安全信息. 包括私有网络的弹性公网 IP(运营商级 NAT 保留地址除外)

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeElasticIpResourcesRequest, self).__init__(
            '/regions/{regionId}/elasticIpResources', 'GET', header, version)
        self.parameters = parameters


class DescribeElasticIpResourcesParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 地域编码. 基础防护已支持华北-北京, 华东-宿迁, 华东-上海, 华南-广州
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.ip = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小
        """
        self.pageSize = pageSize

    def setIp(self, ip):
        """
        :param ip: (Optional) IP 模糊匹配
        """
        self.ip = ip

