# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateApiGroupRequest(JDCloudRequest):
    """
    创建API分组
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateApiGroupRequest, self).__init__(
            '/regions/{regionId}/apiGroups', 'POST', header, version)
        self.parameters = parameters


class CreateApiGroupParameters(object):

    def __init__(self, regionId, groupName, authType, ):
        """
        :param regionId: 地域ID
        :param groupName: 名称
        :param authType: 访问授权方式：None（免鉴权）、jd_cloud（开启访问授权，且必须使用京东云的AK、SK验签）、hufu（虎符用户）
        """

        self.regionId = regionId
        self.groupName = groupName
        self.description = None
        self.prefix = None
        self.keyCheck = None
        self.authType = authType
        self.prefixStrip = None
        self.groupType = None
        self.jdsfName = None
        self.jdsfRegistryName = None
        self.jdsfId = None

    def setDescription(self, description):
        """
        :param description: (Optional) 描述
        """
        self.description = description

    def setPrefix(self, prefix):
        """
        :param prefix: (Optional) 分组路径前缀，无需添加/
        """
        self.prefix = prefix

    def setKeyCheck(self, keyCheck):
        """
        :param keyCheck: (Optional) 密钥验证方式：check_exist（密钥必须在访问授权中已配置）、no_check_exist（无需事先配置）
        """
        self.keyCheck = keyCheck

    def setPrefixStrip(self, prefixStrip):
        """
        :param prefixStrip: (Optional) 是否转发分组路径到后端服务：0（不转发）、1（转发）默认为1
        """
        self.prefixStrip = prefixStrip

    def setGroupType(self, groupType):
        """
        :param groupType: (Optional) 分组类型：api_group（api分组）、jdsf_group（微服务分组）默认为 api_group
        """
        self.groupType = groupType

    def setJdsfName(self, jdsfName):
        """
        :param jdsfName: (Optional) 微服务网关名称
        """
        self.jdsfName = jdsfName

    def setJdsfRegistryName(self, jdsfRegistryName):
        """
        :param jdsfRegistryName: (Optional) 微服务注册中心ID
        """
        self.jdsfRegistryName = jdsfRegistryName

    def setJdsfId(self, jdsfId):
        """
        :param jdsfId: (Optional) 微服务网关ID
        """
        self.jdsfId = jdsfId

