import { ApiObject } from 'cdk8s';
import { Construct } from 'constructs';
import { Resource, ResourceProps, IResource } from './base';
import { ISecret } from './secret';
/**
 * Properties for initialization of `ServiceAccount`.
 *
 * Properties for initialization of `ServiceAccount`.
 *
 * @stability stable
 */
export interface ServiceAccountProps extends ResourceProps {
}
/**
 * @stability stable
 */
export interface IServiceAccount extends IResource {
}
/**
 * Properties for initialization of `ServiceAccount`.
 *
 * Properties for initialization of `ServiceAccount`.
 *
 * @stability stable
 */
export interface ServiceAccountProps {
    /**
     * List of secrets allowed to be used by pods running using this ServiceAccount.
     *
     * @see https://kubernetes.io/docs/concepts/configuration/secret
     * @stability stable
     */
    readonly secrets?: ISecret[];
}
/**
 * A service account provides an identity for processes that run in a Pod.
 *
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 *
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 * @stability stable
 */
export declare class ServiceAccount extends Resource implements IServiceAccount {
    /**
     * Imports a service account from the cluster as a reference.
     *
     * @param name The name of the service account resource.
     * @stability stable
     */
    static fromServiceAccountName(name: string): IServiceAccount;
    /**
     * The underlying cdk8s API object.
     *
     * @see base.Resource.apiObject
     * @stability stable
     */
    protected readonly apiObject: ApiObject;
    private readonly _secrets;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ServiceAccountProps);
    /**
     * Allow a secret to be accessed by pods using this service account.
     *
     * @param secret The secret.
     * @stability stable
     */
    addSecret(secret: ISecret): void;
    /**
     * List of secrets allowed to be used by pods running using this service account.
     *
     * Returns a copy. To add a secret, use `addSecret()`.
     *
     * @stability stable
     */
    get secrets(): ISecret[];
}
