"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SnowflakeConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SnowflakeConnectorType.instance);
        this._location = props.location;
        this._database = props.database;
        this._schema = props.schema ?? SnowflakeConnectorProfile.defaultSchema;
        this.integrationRole = this.tryCreateRole(scope, id, props);
    }
    // INFO: maybe move it to an external class so that it can be either used here or used in any subsequent deployment?
    tryCreateRole(scope, id, props) {
        const properties = props;
        const integration = properties.integration;
        if (!integration) {
            return undefined;
        }
        // INFO: following https://docs.snowflake.com/en/user-guide/data-load-s3-config-storage-integration#configuring-secure-access-to-cloud-storage
        // TODO: currently, the implementation allows read-only access. Make sure that we don't need the write permissions
        return new aws_iam_1.Role(scope, `${id}IntegrationRole`, {
            assumedBy: new aws_iam_1.ArnPrincipal(integration.storageUserArn),
            externalIds: [integration.externalId],
            inlinePolicies: {
                SnowflakeAccess: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            effect: aws_iam_1.Effect.ALLOW,
                            actions: [
                                's3:GetObject',
                                's3:GetObjectVersion',
                            ],
                            resources: [properties.location.bucket.arnForObjects(properties.location.prefix ?? '*')],
                        }),
                        new aws_iam_1.PolicyStatement({
                            effect: aws_iam_1.Effect.ALLOW,
                            actions: [
                                's3:ListBucket',
                                's3:GetBucketLocation',
                            ],
                            resources: [properties.location.bucket.bucketArn],
                            conditions: {
                                StringLike: {
                                    's3:prefix': [properties.location.prefix ?? '*'],
                                },
                            },
                        }),
                    ],
                }),
            },
        });
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            snowflake: {
                username: properties.basicAuth.username,
                password: properties.basicAuth.password?.unsafeUnwrap(),
            },
        };
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        this.tryAddNodeDependency(this, properties.location.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketReadWrite(properties.location.bucket);
        return {
            snowflake: {
                bucketName: properties.location.bucket.bucketName,
                bucketPrefix: properties.location.prefix,
                stage: `${properties.database}.${properties.schema}.${properties.stage}`,
                warehouse: properties.warehouse,
                accountName: properties.account,
                region: properties.region,
            },
        };
    }
}
exports.SnowflakeConnectorProfile = SnowflakeConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SnowflakeConnectorProfile", version: "0.0.36" };
/**
 * Default Snowflake schema if no schema provided
 */
SnowflakeConnectorProfile.defaultSchema = 'PUBLIC';
//# sourceMappingURL=data:application/json;base64,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