import { SecretValue } from 'aws-cdk-lib';
import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
import { S3Location } from '../core/s3-location';
/**
 * Properties for a Snowflake connectorprofile
 */
export interface SnowflakeConnectorProfileProps extends ConnectorProfileProps {
    readonly basicAuth: SnowflakeBasicAuthSettings;
    readonly location: S3Location;
    readonly region?: string;
    readonly account: string;
    /**
     * The name of the Snowflake warehouse
     */
    readonly warehouse: string;
    /**
     * The name of the Snowflake database
     */
    readonly database: string;
    /**
     * The name of the Snowflake schema
     *
     * @default PUBLIC
     */
    readonly schema?: string;
    /**
     * The name of the Snowflake stage
     */
    readonly stage: string;
    /**
     * Details of the Snowflake Storage Integration.
     * When provided, this construct will automatically create an IAM Role allowing access to the S3 Bucket which will be available as a [integrationROle property]{@link SnowflakeConnectorProfile#integrationRole}
     *
     * For details of the integration see {@link https://docs.snowflake.com/en/user-guide/data-load-s3-config-storage-integration}
     */
    readonly integration?: SnowflakeStorageIntegration;
}
/**
 * Snowflake authorization settings required for the profile
 */
export interface SnowflakeBasicAuthSettings {
    readonly username: string;
    readonly password: SecretValue;
}
export interface SnowflakeStorageIntegration {
    readonly storageUserArn: string;
    readonly externalId: string;
}
export declare class SnowflakeConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): SnowflakeConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): SnowflakeConnectorProfile;
    /**
     * Default Snowflake schema if no schema provided
     */
    private static readonly defaultSchema;
    /**
     * This field is used by the SnowflakeDestination to remove repetition
     *
     * @internal
     */
    readonly _location: S3Location;
    /**
     * This field is used by the SnowflakeDestination to remove repetition
     *
     * @internal
     */
    readonly _database: string;
    /**
     * This field is used by the SnowflakeDestination to remove repetition
     *
     * @internal
     */
    readonly _schema: string;
    /**
     * The AWS IAM Role for the storage integration with Snowflake. Available only if [SnowflakeConnectorProfileProps's integration property]{@link SnowflakeConnectorProfileProps#integration} is provided.
     *
     * For more details see {@link https://docs.snowflake.com/en/user-guide/data-load-s3-config-storage-integration}
     */
    readonly integrationRole?: IRole;
    constructor(scope: Construct, id: string, props: SnowflakeConnectorProfileProps);
    private tryCreateRole;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
}
