"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SlackConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SlackConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            slack: {
                instanceUrl: properties.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            slack: {
                accessToken: properties.oAuth.accessToken.unsafeUnwrap(),
                clientId: properties.oAuth.clientId?.unsafeUnwrap() ?? 'dummyClientId',
                clientSecret: properties.oAuth.clientSecret?.unsafeUnwrap() ?? 'dummyClientSecret',
            },
        };
    }
}
exports.SlackConnectorProfile = SlackConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SlackConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SlackConnectorProfile", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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