import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { SalesforceConnectorProfile } from './profile';
import { SalesforceDataTransferApi } from './salesforce-data-transfer-api';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices/source';
export interface SalesforceSourceProps {
    readonly profile: SalesforceConnectorProfile;
    /**
     * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data from Salesforce.
     */
    readonly dataTransferApi?: SalesforceDataTransferApi;
    readonly object: string;
    readonly apiVersion?: string;
    readonly enableDynamicFieldUpdate?: boolean;
    readonly includeDeletedRecords?: boolean;
}
export declare class SalesforceSource implements ISource {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: SalesforceSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
