"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceDataTransferApi = void 0;
/**
 * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
 *
 * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
 *
 * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
 */
var SalesforceDataTransferApi;
(function (SalesforceDataTransferApi) {
    SalesforceDataTransferApi["AUTOMATIC"] = "AUTOMATIC";
    SalesforceDataTransferApi["BULKV2"] = "BULKV2";
    SalesforceDataTransferApi["REST_SYNC"] = "REST_SYNC";
})(SalesforceDataTransferApi || (exports.SalesforceDataTransferApi = SalesforceDataTransferApi = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FsZXNmb3JjZS1kYXRhLXRyYW5zZmVyLWFwaS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zYWxlc2ZvcmNlL3NhbGVzZm9yY2UtZGF0YS10cmFuc2Zlci1hcGkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7Ozs7OztHQU1HO0FBQ0gsSUFBWSx5QkFLWDtBQUxELFdBQVkseUJBQXlCO0lBRW5DLG9EQUF1QixDQUFBO0lBQ3ZCLDhDQUFpQixDQUFBO0lBQ2pCLG9EQUF1QixDQUFBO0FBQ3pCLENBQUMsRUFMVyx5QkFBeUIseUNBQXpCLHlCQUF5QixRQUtwQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogVGhlIGRlZmF1bHQuIEFtYXpvbiBBcHBGbG93IHNlbGVjdHMgd2hpY2ggQVBJIHRvIHVzZSBiYXNlZCBvbiB0aGUgbnVtYmVyIG9mIHJlY29yZHMgdGhhdCB5b3VyIGZsb3cgdHJhbnNmZXJzIHRvIFNhbGVzZm9yY2UuIElmIHlvdXIgZmxvdyB0cmFuc2ZlcnMgZmV3ZXIgdGhhbiAxLDAwMCByZWNvcmRzLCBBbWF6b24gQXBwRmxvdyB1c2VzIFNhbGVzZm9yY2UgUkVTVCBBUEkuIElmIHlvdXIgZmxvdyB0cmFuc2ZlcnMgMSwwMDAgcmVjb3JkcyBvciBtb3JlLCBBbWF6b24gQXBwRmxvdyB1c2VzIFNhbGVzZm9yY2UgQnVsayBBUEkgMi4wLlxuICpcbiAqIEVhY2ggb2YgdGhlc2UgU2FsZXNmb3JjZSBBUElzIHN0cnVjdHVyZXMgZGF0YSBkaWZmZXJlbnRseS4gSWYgQW1hem9uIEFwcEZsb3cgc2VsZWN0cyB0aGUgQVBJIGF1dG9tYXRpY2FsbHksIGJlIGF3YXJlIHRoYXQsIGZvciByZWN1cnJpbmcgZmxvd3MsIHRoZSBkYXRhIG91dHB1dCBtaWdodCB2YXJ5IGZyb20gb25lIGZsb3cgcnVuIHRvIHRoZSBuZXh0LiBGb3IgZXhhbXBsZSwgaWYgYSBmbG93IHJ1bnMgZGFpbHksIGl0IG1pZ2h0IHVzZSBSRVNUIEFQSSBvbiBvbmUgZGF5IHRvIHRyYW5zZmVyIDkwMCByZWNvcmRzLCBhbmQgaXQgbWlnaHQgdXNlIEJ1bGsgQVBJIDIuMCBvbiB0aGUgbmV4dCBkYXkgdG8gdHJhbnNmZXIgMSwxMDAgcmVjb3Jkcy4gRm9yIGVhY2ggb2YgdGhlc2UgZmxvdyBydW5zLCB0aGUgcmVzcGVjdGl2ZSBTYWxlc2ZvcmNlIEFQSSBmb3JtYXRzIHRoZSBkYXRhIGRpZmZlcmVudGx5LiBTb21lIG9mIHRoZSBkaWZmZXJlbmNlcyBpbmNsdWRlIGhvdyBkYXRlcyBhcmUgZm9ybWF0dGVkIGFuZCBudWxsIHZhbHVlcyBhcmUgcmVwcmVzZW50ZWQuIEFsc28sIEJ1bGsgQVBJIDIuMCBkb2Vzbid0IHRyYW5zZmVyIFNhbGVzZm9yY2UgY29tcG91bmQgZmllbGRzLlxuICpcbiAqIEJ5IGNob29zaW5nIHRoaXMgb3B0aW9uLCB5b3Ugb3B0aW1pemUgZmxvdyBwZXJmb3JtYW5jZSBmb3IgYm90aCBzbWFsbCBhbmQgbGFyZ2UgZGF0YSB0cmFuc2ZlcnMsIGJ1dCB0aGUgdHJhZGVvZmYgaXMgaW5jb25zaXN0ZW50IGZvcm1hdHRpbmcgaW4gdGhlIG91dHB1dC5cbiAqL1xuZXhwb3J0IGVudW0gU2FsZXNmb3JjZURhdGFUcmFuc2ZlckFwaSB7XG5cbiAgQVVUT01BVElDID0gJ0FVVE9NQVRJQycsXG4gIEJVTEtWMiA9ICdCVUxLVjInLFxuICBSRVNUX1NZTkMgPSAnUkVTVF9TWU5DJ1xufVxuIl19