"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Source = exports.S3InputFileType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
/**
 * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
 */
var S3InputFileType;
(function (S3InputFileType) {
    S3InputFileType["CSV"] = "CSV";
    S3InputFileType["JSON"] = "JSON";
})(S3InputFileType || (exports.S3InputFileType = S3InputFileType = {}));
class S3Source {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.S3ConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketRead(this.props.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            s3: {
                bucketName: this.props.bucket.bucketName,
                bucketPrefix: this.props.prefix,
                s3InputFormatConfig: this.props.format && {
                    s3InputFileType: this.props.format.type,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.S3Source = S3Source;
_a = JSII_RTTI_SYMBOL_1;
S3Source[_a] = { fqn: "@cdklabs/cdk-appflow.S3Source", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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