import { Database } from '@aws-cdk/aws-glue-alpha';
import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { S3Location } from '../core/s3-location';
import { IDestination } from '../core/vertices/destination';
export interface S3FileAggregation {
    readonly type?: S3OutputAggregationType;
    /**
     * The maximum size, in MB, of the file containing portion of incoming data
     */
    readonly fileSize?: number;
}
export interface S3OutputFilePrefix {
    readonly hierarchy?: S3OutputFilePrefixHierarchy[];
    readonly format?: S3OutputFilePrefixFormat;
    readonly type?: S3OutputFilePrefixType;
}
export interface S3OutputFormatting {
    readonly aggregation?: S3FileAggregation;
    readonly fileType?: S3OutputFileType;
    readonly filePrefix?: S3OutputFilePrefix;
    readonly preserveSourceDataTypes?: boolean;
}
export declare enum S3OutputAggregationType {
    NONE = "None",
    SINGLE_FILE = "SingleFile"
}
export declare enum S3OutputFileType {
    CSV = "CSV",
    JSON = "JSON",
    PARQUET = "PARQUET"
}
export declare enum S3OutputFilePrefixHierarchy {
    EXECUTION_ID = "EXECUTION_ID",
    SCHEMA_VERSION = "SCHEMA_VERSION"
}
export declare enum S3OutputFilePrefixFormat {
    DAY = "DAY",
    HOUR = "HOUR",
    MINUTE = "MINUTE",
    MONTH = "MONTH",
    YEAR = "YEAR"
}
export declare enum S3OutputFilePrefixType {
    FILENAME = "FILENAME",
    PATH = "PATH",
    PATH_AND_FILE = "PATH_AND_FILE"
}
export interface S3Catalog {
    readonly database: Database;
    readonly tablePrefix: string;
}
export interface S3DestinationProps {
    readonly location: S3Location;
    readonly catalog?: S3Catalog;
    readonly formatting?: S3OutputFormatting;
}
export declare class S3Destination implements IDestination {
    private readonly props;
    readonly connectorType: ConnectorType;
    private readonly compatibleFlows;
    constructor(props: S3DestinationProps);
    private buildAggregationConfig;
    private buildPrefixConfig;
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    /**
     * see: https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-access-gdc
     * see: https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-gdc
     * @param flow
     * @returns a tuple consisting of a role for cataloguing with a specified policy
     */
    private buildRoleAndPolicyForCatalog;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
