"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcSmallDataScaleConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const core_1 = require("../core");
const connector_profile_1 = require("../core/connectors/connector-profile");
/**
 * The connector profile for the JDBC connector
 */
class JdbcSmallDataScaleConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    /**
     * Imports an existing JdbcSmallDataScaleConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param arn the ARN for the existing connector profile
     * @returns An instance of the JdbcSmallDataScaleConnectorProfile
     */
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    /**
     * Imports an existing JdbcSmallDataScaleConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param name the name for the existing connector profile
     * @returns An instance of the JdbcSmallDataScaleConnectorProfile
     */
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    /**
     * Creates a new instance of the JdbcSmallDataScaleConnectorProfile
     * @param scope the Construct scope for this connector profile
     * @param id the id of this connector profile
     * @param props properties to use when instantiating this connector profile
     */
    constructor(scope, id, props) {
        super(scope, id, props, type_1.JdbcSmallDataScaleConnectorType.instance);
    }
    buildConnectorProfileProperties(_props) {
        return {
            customConnector: {
                profileProperties: {},
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                authenticationType: core_1.ConnectorAuthenticationType.CUSTOM,
                custom: {
                    credentialsMap: {
                        username: properties.basicAuth.username,
                        password: properties.basicAuth.password.unsafeUnwrap(),
                        driver: properties.driver,
                        hostname: properties.hostname,
                        port: `${properties.port}`,
                        database: properties.database,
                    },
                    customAuthenticationType: 'CUSTOM',
                },
            },
        };
    }
}
exports.JdbcSmallDataScaleConnectorProfile = JdbcSmallDataScaleConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
JdbcSmallDataScaleConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.JdbcSmallDataScaleConnectorProfile", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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