"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAdsSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
/**
 * A class that represents a Google Ads v4 Source
 */
class GoogleAdsSource {
    constructor(props) {
        this.props = props;
        /**
           * The AppFlow type of the connector that this source is implemented for
           */
        this.connectorType = type_1.GoogleAdsConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.GoogleAdsSource = GoogleAdsSource;
_a = JSII_RTTI_SYMBOL_1;
GoogleAdsSource[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAdsSource", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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