"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WriteOperation = exports.WriteOperationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
var WriteOperationType;
(function (WriteOperationType) {
    WriteOperationType["DELETE"] = "DELETE";
    WriteOperationType["INSERT"] = "INSERT";
    WriteOperationType["UPDATE"] = "UPDATE";
    WriteOperationType["UPSERT"] = "UPSERT";
})(WriteOperationType || (exports.WriteOperationType = WriteOperationType = {}));
class WriteOperation {
    static insert(ids) { return new WriteOperation(WriteOperationType.INSERT, ids); }
    static delete(ids) { return new WriteOperation(WriteOperationType.DELETE, ids); }
    static update(ids) { return new WriteOperation(WriteOperationType.UPDATE, ids); }
    static upsert(ids) { return new WriteOperation(WriteOperationType.UPSERT, ids); }
    constructor(type, ids) {
        this.type = type;
        this.ids = ids;
    }
}
exports.WriteOperation = WriteOperation;
_a = JSII_RTTI_SYMBOL_1;
WriteOperation[_a] = { fqn: "@cdklabs/cdk-appflow.WriteOperation", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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