"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Validation = exports.ValidationAction = exports.ValidationCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
/**
 * A representation of a validation condition on a particular field in a flow execution
 */
class ValidationCondition {
    /**
     * Validates whether a particular field in an execution is negative
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNegative(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NON_NEGATIVE');
    }
    /**
     * Validates whether a particular field has no value
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNull(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NON_NULL');
    }
    // TODO: make sure that you understand what's here
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNotNull(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NUMERIC');
    }
    // TODO: make sure that you understand what's here
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isDefault(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NON_ZERO');
    }
    constructor(field, validation) {
        this.field = field;
        this.validation = validation;
    }
}
exports.ValidationCondition = ValidationCondition;
_a = JSII_RTTI_SYMBOL_1;
ValidationCondition[_a] = { fqn: "@cdklabs/cdk-appflow.ValidationCondition", version: "0.0.36" };
class ValidationAction {
    /**
     *
     * @returns a @see ValidationAction that removes a record from the flow execution result
     */
    static ignoreRecord() { return new ValidationAction('DropRecord'); }
    /**
     *
     * @returns a @see ValidationAction that terminates the whole flow execution
     */
    static terminateFlow() { return new ValidationAction('DropDataset'); }
    constructor(action) {
        this.action = action;
    }
}
exports.ValidationAction = ValidationAction;
_b = JSII_RTTI_SYMBOL_1;
ValidationAction[_b] = { fqn: "@cdklabs/cdk-appflow.ValidationAction", version: "0.0.36" };
/**
 * A representation of a validation operation, that is an operation testing records and acting on the test results
 */
class Validation extends operation_1.OperationBase {
    /**
     *
     * @param condition a @see ValidationCondition for the validation
     * @param action a @see ValidationAction for the validation
     * @returns a Validation instance
     */
    static when(condition, action) {
        return new Validation(condition, action);
    }
    constructor(condition, action) {
        super([new tasks_1.Task('Validate', [condition.field], { operation: condition.validation }, [{ key: 'VALIDATION_ACTION', value: action.action }])]);
        this.condition = condition;
        this.action = action;
    }
}
exports.Validation = Validation;
_c = JSII_RTTI_SYMBOL_1;
Validation[_c] = { fqn: "@cdklabs/cdk-appflow.Validation", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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