import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { ITask } from './tasks';
import { IFlow } from '../flows/flow-base';
import { ISource } from '../vertices/source';
/**
 * A representation of a set of tasks that deliver complete operation
 */
export interface IOperation {
    bind(flow: IFlow, source: ISource): CfnFlow.TaskProperty[];
}
/**
 * A base class for all operations
 */
export declare abstract class OperationBase implements IOperation {
    private readonly tasks;
    constructor(tasks: ITask[]);
    bind(flow: IFlow, source: ISource): CfnFlow.TaskProperty[];
}
