"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlowTimeUpdater = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
// import * as path from 'path';
const aws_cdk_lib_1 = require("aws-cdk-lib");
// import { Runtime } from 'aws-cdk-lib/aws-lambda';
// import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const api = require("./api");
const flow_time_updater_function_1 = require("./flow-time-updater-function");
class FlowTimeUpdater extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: FlowTimeUpdaterProvider.getOrCreate(this),
            resourceType: 'Custom::FlowTimeUpdater',
            properties: {
                [api.PROP_SCHEDULE]: props.schedule.expressionString,
                [api.PROP_STARTTIME]: props.startTime && props.startTime.toISOString(),
                [api.PROP_ENDTIME]: props.endTime && props.endTime.toISOString(),
            },
        });
        this.scheduleExpression = resource.getAttString(api.ATTR_SCHEDULE);
        this.startTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_STARTTIME));
        this.endTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_ENDTIME));
    }
}
exports.FlowTimeUpdater = FlowTimeUpdater;
class FlowTimeUpdaterProvider extends constructs_1.Construct {
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = 'com.amazonaws.cdk.custom-resources.flow-time-provider';
        const x = stack.node.tryFindChild(id) || new FlowTimeUpdaterProvider(stack, id);
        return x.provider.serviceToken;
    }
    constructor(scope, id) {
        super(scope, id);
        this.provider = new custom_resources_1.Provider(this, 'flow-time-provider', {
            onEventHandler: new flow_time_updater_function_1.FlowTimeUpdaterFunction(this, 'flow-time-on-event'),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmxvdy10aW1lLXVwZGF0ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvY29yZS9mbG93cy9mbG93LXRpbWUtdXBkYXRlci9mbG93LXRpbWUtdXBkYXRlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTs7O0VBR0U7QUFDRixnQ0FBZ0M7QUFDaEMsNkNBQTJEO0FBRTNELG9EQUFvRDtBQUNwRCxrRUFBa0U7QUFDbEUsbUVBQXdEO0FBQ3hELDJDQUF1QztBQUN2Qyw2QkFBNkI7QUFDN0IsNkVBQXVFO0FBUXZFLE1BQWEsZUFBZ0IsU0FBUSxzQkFBUztJQUs1QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTJCO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxRQUFRLEdBQUcsSUFBSSw0QkFBYyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDcEQsWUFBWSxFQUFFLHVCQUF1QixDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUM7WUFDdkQsWUFBWSxFQUFFLHlCQUF5QjtZQUN2QyxVQUFVLEVBQUU7Z0JBQ1YsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0I7Z0JBQ3BELENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUU7Z0JBQ3RFLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxFQUFFLEtBQUssQ0FBQyxPQUFPLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUU7YUFDakU7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsUUFBUSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDbkUsSUFBSSxDQUFDLFNBQVMsR0FBRyxtQkFBSyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO1FBQ3JFLElBQUksQ0FBQyxPQUFPLEdBQUcsbUJBQUssQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRSxDQUFDO0NBQ0Y7QUF0QkQsMENBc0JDO0FBRUQsTUFBTSx1QkFBd0IsU0FBUSxzQkFBUztJQUU3Qzs7T0FFRztJQUNJLE1BQU0sQ0FBQyxXQUFXLENBQUMsS0FBZ0I7UUFDeEMsTUFBTSxLQUFLLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDOUIsTUFBTSxFQUFFLEdBQUcsdURBQXVELENBQUM7UUFDbkUsTUFBTSxDQUFDLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUE0QixJQUFJLElBQUksdUJBQXVCLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzNHLE9BQU8sQ0FBQyxDQUFDLFFBQVEsQ0FBQyxZQUFZLENBQUM7SUFDakMsQ0FBQztJQUlELFlBQVksS0FBZ0IsRUFBRSxFQUFVO1FBQ3RDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLDJCQUFRLENBQUMsSUFBSSxFQUFFLG9CQUFvQixFQUFFO1lBQ3ZELGNBQWMsRUFBRSxJQUFJLG9EQUF1QixDQUFDLElBQUksRUFBRSxvQkFBb0IsQ0FBQztTQUN4RSxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbi8vIGltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBDdXN0b21SZXNvdXJjZSwgU3RhY2ssIFRva2VuIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgU2NoZWR1bGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZXZlbnRzJztcbi8vIGltcG9ydCB7IFJ1bnRpbWUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbi8vIGltcG9ydCB7IE5vZGVqc0Z1bmN0aW9uIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYS1ub2RlanMnO1xuaW1wb3J0IHsgUHJvdmlkZXIgfSBmcm9tICdhd3MtY2RrLWxpYi9jdXN0b20tcmVzb3VyY2VzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgYXBpIGZyb20gJy4vYXBpJztcbmltcG9ydCB7IEZsb3dUaW1lVXBkYXRlckZ1bmN0aW9uIH0gZnJvbSAnLi9mbG93LXRpbWUtdXBkYXRlci1mdW5jdGlvbic7XG5cbmludGVyZmFjZSBGbG93VGltZVVwZGF0ZXJQcm9wcyB7XG4gIHJlYWRvbmx5IHNjaGVkdWxlOiBTY2hlZHVsZTtcbiAgcmVhZG9ubHkgc3RhcnRUaW1lPzogRGF0ZTtcbiAgcmVhZG9ubHkgZW5kVGltZT86IERhdGU7XG59XG5cbmV4cG9ydCBjbGFzcyBGbG93VGltZVVwZGF0ZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgc2NoZWR1bGVFeHByZXNzaW9uOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBzdGFydFRpbWU/OiBudW1iZXI7XG4gIHB1YmxpYyByZWFkb25seSBlbmRUaW1lPzogbnVtYmVyO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBGbG93VGltZVVwZGF0ZXJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDdXN0b21SZXNvdXJjZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IEZsb3dUaW1lVXBkYXRlclByb3ZpZGVyLmdldE9yQ3JlYXRlKHRoaXMpLFxuICAgICAgcmVzb3VyY2VUeXBlOiAnQ3VzdG9tOjpGbG93VGltZVVwZGF0ZXInLFxuICAgICAgcHJvcGVydGllczoge1xuICAgICAgICBbYXBpLlBST1BfU0NIRURVTEVdOiBwcm9wcy5zY2hlZHVsZS5leHByZXNzaW9uU3RyaW5nLFxuICAgICAgICBbYXBpLlBST1BfU1RBUlRUSU1FXTogcHJvcHMuc3RhcnRUaW1lICYmIHByb3BzLnN0YXJ0VGltZS50b0lTT1N0cmluZygpLFxuICAgICAgICBbYXBpLlBST1BfRU5EVElNRV06IHByb3BzLmVuZFRpbWUgJiYgcHJvcHMuZW5kVGltZS50b0lTT1N0cmluZygpLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMuc2NoZWR1bGVFeHByZXNzaW9uID0gcmVzb3VyY2UuZ2V0QXR0U3RyaW5nKGFwaS5BVFRSX1NDSEVEVUxFKTtcbiAgICB0aGlzLnN0YXJ0VGltZSA9IFRva2VuLmFzTnVtYmVyKHJlc291cmNlLmdldEF0dChhcGkuQVRUUl9TVEFSVFRJTUUpKTtcbiAgICB0aGlzLmVuZFRpbWUgPSBUb2tlbi5hc051bWJlcihyZXNvdXJjZS5nZXRBdHQoYXBpLkFUVFJfRU5EVElNRSkpO1xuICB9XG59XG5cbmNsYXNzIEZsb3dUaW1lVXBkYXRlclByb3ZpZGVyIGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgc2luZ2xldG9uIHByb3ZpZGVyLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBnZXRPckNyZWF0ZShzY29wZTogQ29uc3RydWN0KSB7XG4gICAgY29uc3Qgc3RhY2sgPSBTdGFjay5vZihzY29wZSk7XG4gICAgY29uc3QgaWQgPSAnY29tLmFtYXpvbmF3cy5jZGsuY3VzdG9tLXJlc291cmNlcy5mbG93LXRpbWUtcHJvdmlkZXInO1xuICAgIGNvbnN0IHggPSBzdGFjay5ub2RlLnRyeUZpbmRDaGlsZChpZCkgYXMgRmxvd1RpbWVVcGRhdGVyUHJvdmlkZXIgfHwgbmV3IEZsb3dUaW1lVXBkYXRlclByb3ZpZGVyKHN0YWNrLCBpZCk7XG4gICAgcmV0dXJuIHgucHJvdmlkZXIuc2VydmljZVRva2VuO1xuICB9XG5cbiAgcHJpdmF0ZSByZWFkb25seSBwcm92aWRlcjogUHJvdmlkZXI7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnByb3ZpZGVyID0gbmV3IFByb3ZpZGVyKHRoaXMsICdmbG93LXRpbWUtcHJvdmlkZXInLCB7XG4gICAgICBvbkV2ZW50SGFuZGxlcjogbmV3IEZsb3dUaW1lVXBkYXRlckZ1bmN0aW9uKHRoaXMsICdmbG93LXRpbWUtb24tZXZlbnQnKSxcbiAgICB9KTtcbiAgfVxufSJdfQ==