"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZendeskDestination = void 0;
const type_1 = require("./type");
class ZendeskDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.ZendeskConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            zendesk: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                idFieldNames: this.props.operation.ids,
                object: this.props.object,
                writeOperationType: this.props.operation.type,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource) {
            scope.node.addDependency(resource);
        }
    }
}
exports.ZendeskDestination = ZendeskDestination;
//# sourceMappingURL=data:application/json;base64,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