import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { SnowflakeConnectorProfile } from './profile';
import { ErrorHandlingConfiguration, IFlow } from '../core';
import { ConnectorType } from '../core/connectors/connector-type';
import { IDestination } from '../core/vertices';
/**
 * The destination table in Snowflake. The table needs to reside in the databas and schema provided in the profile.
 */
export interface SnowflakeDestinationObject {
    /**
     * The name of the table object
     */
    readonly table: string;
}
/**
 * Properties that are required to create a Snowflake destination.
 */
export interface SnowflakeDestinationProps {
    /**
     * A Snowflake connector profile instance.
     */
    readonly profile: SnowflakeConnectorProfile;
    /**
     * A Snowflake table object (optionally with the schema).
     */
    readonly object: SnowflakeDestinationObject;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
}
/**
 * A Snowflake destination.
 */
export declare class SnowflakeDestination implements IDestination {
    private readonly props;
    private readonly _connectorType;
    get connectorType(): ConnectorType;
    constructor(props: SnowflakeDestinationProps);
    bind(scope: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private buildObject;
    private tryAddNodeDependency;
}
