import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { SlackConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices/source';
export interface SlackSourceProps {
    readonly profile: SlackConnectorProfile;
    readonly object: string;
    readonly apiVersion?: string;
}
export declare class SlackSource implements ISource {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: SlackSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
