import { SecretValue } from 'aws-cdk-lib';
import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface MicrosoftSharepointOnlineConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: MicrosoftSharepointOnlineOAuthSettings;
}
export interface MicrosoftSharepointOnlineOAuthEndpointsSettings {
    readonly token: string;
}
export interface MicrosoftSharepointOnlineRefreshTokenGrantFlow {
    readonly refreshToken?: SecretValue;
    readonly clientSecret?: SecretValue;
    readonly clientId?: SecretValue;
}
export interface MicrosoftSharepointOnlineOAuthFlow {
    readonly refreshTokenGrant: MicrosoftSharepointOnlineRefreshTokenGrantFlow;
}
export interface MicrosoftSharepointOnlineOAuthSettings {
    /**
     * The access token to be used when interacting with Microsoft Sharepoint Online
     *
     * Note that if only the access token is provided AppFlow is not able to retrieve a fresh access token when the current one is expired
     */
    readonly accessToken?: SecretValue;
    readonly flow?: MicrosoftSharepointOnlineOAuthFlow;
    readonly endpoints?: MicrosoftSharepointOnlineOAuthEndpointsSettings;
}
/**
 * A class that represents a Microsoft Sharepoint Online Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Sharepoint Online's site to Amazon S3.
 */
export declare class MicrosoftSharepointOnlineConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): MicrosoftSharepointOnlineConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): MicrosoftSharepointOnlineConnectorProfile;
    private static readonly defaultTokenEndpoint;
    constructor(scope: Construct, id: string, props: MicrosoftSharepointOnlineConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
