import { SecretValue } from 'aws-cdk-lib';
import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface MicrosoftDynamics365ConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: MicrosoftDynamics365OAuthSettings;
    readonly instanceUrl: string;
}
export interface MicrosoftDynamics365OAuthEndpointsSettings {
    readonly token: string;
}
export interface MicrosoftDynamics365RefreshTokenGrantFlow {
    readonly refreshToken?: SecretValue;
    readonly clientSecret?: SecretValue;
    readonly clientId?: SecretValue;
}
export interface MicrosoftDynamics365OAuthFlow {
    readonly refreshTokenGrant: MicrosoftDynamics365RefreshTokenGrantFlow;
}
export interface MicrosoftDynamics365OAuthSettings {
    /**
     * The access token to be used when interacting with Microsoft Dynamics 365
     *
     * Note that if only the access token is provided AppFlow is not able to retrieve a fresh access token when the current one is expired
     */
    readonly accessToken?: SecretValue;
    readonly flow?: MicrosoftDynamics365OAuthFlow;
    readonly endpoints?: MicrosoftDynamics365OAuthEndpointsSettings;
}
/**
 * A class that represents a Microsoft Dynamics 365 Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Dynamics 365's site to Amazon S3.
 */
export declare class MicrosoftDynamics365ConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): MicrosoftDynamics365ConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): MicrosoftDynamics365ConnectorProfile;
    private static readonly defaultTokenEndpoint;
    constructor(scope: Construct, id: string, props: MicrosoftDynamics365ConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
