import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { ConnectorType } from '../core/connectors/connector-type';
import { ErrorHandlingConfiguration } from '../core/error-handling';
import { IFlow } from '../core/flows';
import { IDestination } from '../core/vertices/destination';
import { MarketoConnectorProfile } from '../marketo/profile';
export interface MarketoDestinationProps {
    readonly profile: MarketoConnectorProfile;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Marketo destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
    /**
     * The Marketo object for which the operation is to be set.
     */
    readonly object: string;
}
export declare class MarketoDestination implements IDestination {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: MarketoDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
