"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailchimpSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
/**
 * A class that represents a Mailchimp v3 Source
 */
class MailchimpSource {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.MailchimpConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion,
            connectorProfileName: this.props.profile.name,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.MailchimpSource = MailchimpSource;
_a = JSII_RTTI_SYMBOL_1;
MailchimpSource[_a] = { fqn: "@cdklabs/cdk-appflow.MailchimpSource", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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