import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { MailchimpConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices';
export interface MailchimpSourceProps {
    readonly profile: MailchimpConnectorProfile;
    readonly apiVersion: string;
    readonly object: string;
}
/**
 * A class that represents a Mailchimp v3 Source
 */
export declare class MailchimpSource implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: MailchimpSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
