"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailchimpConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
/**
 * A class that represents a Mailchimp Connector Profile.
 *
 */
class MailchimpConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MailchimpConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.CUSTOM,
                custom: {
                    credentialsMap: {
                        api_key: properties.apiKey.unsafeUnwrap(),
                    },
                    customAuthenticationType: 'api_key',
                },
            },
        };
    }
}
exports.MailchimpConnectorProfile = MailchimpConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MailchimpConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MailchimpConnectorProfile", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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