"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleBigQueryConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class GoogleBigQueryConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.GoogleBigQueryConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ?? GoogleBigQueryConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? 'dummyAccessToken',
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.GoogleBigQueryConnectorProfile = GoogleBigQueryConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
GoogleBigQueryConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleBigQueryConnectorProfile", version: "0.0.36" };
GoogleBigQueryConnectorProfile.defaultTokenEndpoint = 'https://oauth2.googleapis.com/token';
//# sourceMappingURL=data:application/json;base64,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