"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAdsConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class GoogleAdsConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.GoogleAdsConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                profileProperties: {
                    developerToken: properties.developerToken.unsafeUnwrap(),
                    apiVersion: properties.apiVersion,
                    managerID: properties.managerID?.unsafeUnwrap() /* can be undefined */,
                },
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    tokenUrl: properties.oAuth.endpoints?.token ?? GoogleAdsConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? 'dummyAccessToken',
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.GoogleAdsConnectorProfile = GoogleAdsConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
GoogleAdsConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAdsConnectorProfile", version: "0.0.36" };
GoogleAdsConnectorProfile.defaultTokenEndpoint = 'https://oauth2.googleapis.com/token';
//# sourceMappingURL=data:application/json;base64,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