"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A representation of a unitary action on the record fields
 */
class Task {
    constructor(type, sourceFields, connectorOperator, properties, destinationField) {
        this.type = type;
        this.sourceFields = sourceFields;
        this.connectorOperator = connectorOperator;
        this.properties = properties;
        this.destinationField = destinationField;
    }
    bind(_flow, source) {
        return {
            taskType: this.type,
            sourceFields: this.sourceFields,
            taskProperties: this.properties.map(({ key, value }) => ({ key: key, value: value })),
            connectorOperator: this.buildOperatorFor(source),
            destinationField: this.destinationField,
        };
    }
    buildOperatorFor(source) {
        const operator = {};
        const origin = this.connectorOperator.type?.asTaskConnectorOperatorOrigin ?? source.connectorType.asTaskConnectorOperatorOrigin;
        operator[origin] = this.connectorOperator.operation;
        return operator;
    }
}
exports.Task = Task;
_a = JSII_RTTI_SYMBOL_1;
Task[_a] = { fqn: "@cdklabs/cdk-appflow.Task", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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