"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mapping = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
const TT_MAPALL = 'Map_all';
const TT_MAP = 'Map';
const TT_MERGE = 'Merge';
const TT_ARITHMETIC = 'Arithmetic';
const OP_NOOP = 'NO_OP';
const OP_ADDITION = 'ADDITION';
const OP_SUBTRACTION = 'SUBTRACTION';
const OP_MULTIPLICATION = 'MULTIPLICATION';
const OP_DIVISION = 'DIVISION';
const TP_SOURCE_DATA_TYPE = 'SOURCE_DATA_TYPE';
const TP_DESTINATION_DATA_TYPE = 'DESTINATION_DATA_TYPE';
/**
 * A representation of an instance of a mapping operation, that is an operation translating source to destination fields
 */
class Mapping extends operation_1.OperationBase {
    static mapAll(config) {
        return new Mapping([
            new tasks_1.Task(TT_MAPALL, [], { operation: OP_NOOP }, [{ key: 'EXCLUDE_SOURCE_FIELDS_LIST', value: config ? `["${aws_cdk_lib_1.Fn.join('","', config.exclude)}"]` : '[]' }]),
        ]);
    }
    static map(from, to) {
        const props = [];
        if (from.dataType) {
            props.push({ key: TP_SOURCE_DATA_TYPE, value: from.dataType });
        }
        if (to.dataType) {
            props.push({ key: TP_DESTINATION_DATA_TYPE, value: to.dataType });
        }
        return new Mapping([
            new tasks_1.Task(TT_MAP, [from.name], { operation: OP_NOOP }, props, to.name),
        ]);
    }
    /**
     * A mapping definition building concatenation of source fields into a destination field
     * @param from an array of source fields
     * @param to a desintation field
     * @param format a format
     * @returns a mapping instance with concatenation definition
     */
    static concat(from, to, format) {
        if (!to.dataType) {
            throw new Error('dataType for \'to\' required');
        }
        const tmpField = from.map(f => f.name).join(',');
        return new Mapping([
            new tasks_1.Task(TT_MERGE, from.map(f => f.name), { operation: OP_NOOP }, [{ key: 'CONCAT_FORMAT', value: format }], tmpField),
            new tasks_1.Task(TT_MAP, [tmpField], { operation: OP_NOOP }, [
                { key: 'DESTINATION_DATA_TYPE', value: to.dataType },
                { key: 'SOURCE_DATA_TYPE', value: 'string' },
            ]),
        ]);
    }
    /**
     * Specifies an addition mapping of two numeric values from asource to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static add(sourceField1, sourceField2, to) {
        return Mapping.arithmetic(sourceField1, sourceField2, to, OP_ADDITION);
    }
    /**
     * Specifies a multiplication mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static multiply(sourceField1, sourceField2, to) {
        return Mapping.arithmetic(sourceField1, sourceField2, to, OP_MULTIPLICATION);
    }
    /**
     * Specifies a subtraction mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static subtract(sourceField1, sourceField2, to) {
        return Mapping.arithmetic(sourceField1, sourceField2, to, OP_SUBTRACTION);
    }
    /**
     * Specifies a division mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static divide(sourceField1, sourceField2, to) {
        return Mapping.arithmetic(sourceField1, sourceField2, to, OP_DIVISION);
    }
    /**
     * Specifies an arithmetic mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static arithmetic(sourceField1, sourceField2, to, operation) {
        if (!to.dataType) {
            throw new Error('dataType for \'to\' required');
        }
        const tmpField = `${sourceField1.name},${sourceField2.name}`;
        return new Mapping([
            new tasks_1.Task(TT_ARITHMETIC, [sourceField1.name, sourceField2.name], { operation: operation }, [{
                    key: 'MATH_OPERATION_FIELDS_ORDER', value: tmpField,
                }], tmpField),
            new tasks_1.Task(TT_MAP, [tmpField], { operation: OP_NOOP }, [
                { key: 'DESTINATION_DATA_TYPE', value: to.dataType },
                { key: 'SOURCE_DATA_TYPE', value: 'string' },
            ], to.name),
        ]);
    }
}
exports.Mapping = Mapping;
_a = JSII_RTTI_SYMBOL_1;
Mapping[_a] = { fqn: "@cdklabs/cdk-appflow.Mapping", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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