# MCP Vector Search Documentation

Welcome to the comprehensive documentation for **MCP Vector Search** - a CLI-first semantic code search tool with MCP integration.

## 📍 Quick Navigation

### 🚀 New Users Start Here
- **[Getting Started](getting-started/README.md)** - Installation, configuration, and first steps
- **[User Guides](guides/README.md)** - How-to guides for common tasks
- **[Reference](reference/README.md)** - Complete CLI and feature reference

### 👨‍💻 Developers
- **[Development](development/README.md)** - Contributing, architecture, and APIs
- **[Architecture](architecture/README.md)** - Design decisions and system architecture

### 🔧 Advanced Users
- **[Advanced Topics](advanced/README.md)** - Performance tuning, troubleshooting, and extensions

---

## 📚 Documentation Sections

### Getting Started
Perfect for new users getting up and running quickly.

- [Installation Guide](getting-started/installation.md) - Install and deploy
- [Configuration](getting-started/configuration.md) - Configure your project
- [First Steps Tutorial](getting-started/first-steps.md) - Your first search

### Guides
Step-by-step guides for specific tasks.

- [CLI Usage](guides/cli-usage.md) - Command-line features and usage
- [MCP Integration](guides/mcp-integration.md) - Integrate with Claude Desktop, Cursor, etc.
- [File Watching](guides/file-watching.md) - Auto-update your index
- [Searching Code](guides/searching.md) - Search strategies and tips
- [Indexing Code](guides/indexing.md) - Indexing strategies and best practices
- [Chat Command](guides/chat-command.md) - LLM-powered intelligent code search

### Reference
Technical reference documentation.

- [CLI Commands](reference/cli-commands.md) - Complete command reference
- [Configuration Options](reference/configuration-options.md) - All configuration settings
- [Supported Languages](reference/supported-languages.md) - Language support matrix
- [Architecture Overview](reference/architecture.md) - Project structure
- [Features](reference/features.md) - Complete feature list

### Development
For contributors and maintainers.

- [Development Setup](development/setup.md) - Set up development environment
- [Contributing Guide](development/contributing.md) - How to contribute
- [Architecture Guide](development/architecture.md) - Technical architecture deep dive
- [API Reference](development/api.md) - Internal API documentation
- [Testing Guide](development/testing.md) - Testing strategies and guidelines
- [Code Quality](development/code-quality.md) - Linting, formatting, type checking
- [Project Organization](development/project-organization.md) - File organization standards
- [Versioning & Releases](development/versioning.md) - Version management and release process

### Architecture
Design and architecture documentation.

- [Architecture Overview](architecture/overview.md) - High-level system design
- [Indexing Workflow](architecture/indexing-workflow.md) - How indexing works
- [Performance](architecture/performance.md) - Performance optimizations
- [Design Decisions](architecture/design-decisions.md) - Key architectural decisions

### Deployment
Release management and distribution.

- [Release Process](deployment/RELEASES.md) - Release workflow and best practices
- [Version History](deployment/CHANGELOG.md) - Complete changelog
- [Versioning System](deployment/VERSIONING_WORKFLOW.md) - Version management
- [Homebrew Integration](deployment/HOMEBREW_INTEGRATION.md) - Automated distribution

### Configuration
Configuration management and options.

- [Configuration Reference](configuration/README.md) - Centralized configuration docs
- [Project Settings](getting-started/configuration.md) - Basic configuration guide
- [Advanced Configuration](reference/configuration-options.md) - Complete options reference

### Advanced Topics
For power users and advanced use cases.

- [Performance Tuning](advanced/performance-tuning.md) - Optimize for your use case
- [Embedding Models](advanced/embedding-models.md) - Choose and configure models
- [Troubleshooting](advanced/troubleshooting.md) - Common issues and solutions
- [Extending MCP Vector Search](advanced/extending.md) - Add languages, parsers, etc.

### Internal Documentation
Analysis, reports, and development notes.

- [Analysis Reports](internal/README.md) - Search analysis and improvements
- [Improvements Summary](internal/improvements.md) - Development improvements
- [Refactoring Analysis](internal/refactoring-analysis.md) - Code refactoring notes
- [Install Enhancements](internal/install-enhancements.md) - Install command evolution

### Research
Research notes and investigations.

- [Research Index](research/README.md) - Research documentation index
- [Performance Studies](research/) - Performance analysis and optimization research
- [Feature Research](research/) - New feature investigations and prototypes

---

## 🗂️ Other Resources

### Important Files
- **[CHANGELOG](deployment/CHANGELOG.md)** - Version history and release notes
- **[README](../README.md)** - Project overview (in repository root)
- **[LICENSE](../LICENSE)** - MIT License
- **[Documentation Standards](DOCUMENTATION-STANDARDS.md)** - Documentation organization standards

### Product Documentation
- **[Product Requirements](prd/)** - Product specifications and requirements

### Archive
- **[Archived Documentation](_archive/)** - Historical and deprecated documentation

---

## 🔍 Finding What You Need

### I want to...

**Get started quickly**
→ [Getting Started](getting-started/README.md)

**Search my code**
→ [Searching Guide](guides/searching.md) | [CLI Commands](reference/cli-commands.md)

**Configure my project**
→ [Configuration Guide](getting-started/configuration.md)

**Integrate with my IDE**
→ [MCP Integration](guides/mcp-integration.md)

**Contribute to the project**
→ [Contributing Guide](development/contributing.md)

**Understand how it works**
→ [Architecture Overview](architecture/overview.md)

**Optimize performance**
→ [Performance Tuning](advanced/performance-tuning.md)

**Troubleshoot issues**
→ [Troubleshooting](advanced/troubleshooting.md)

**Add a new language**
→ [Extending Guide](advanced/extending.md)

---

## 📝 Documentation Standards

All documentation follows these standards:
- Clear headings and table of contents
- Code examples with language hints
- Cross-references to related documentation
- Consistent formatting and structure

See [Project Organization](development/project-organization.md) for complete standards.

---

## 🆘 Need Help?

- **Issues**: [GitHub Issues](https://github.com/bobmatnyc/mcp-vector-search/issues)
- **Discussions**: [GitHub Discussions](https://github.com/bobmatnyc/mcp-vector-search/discussions)
- **Questions**: Check [Troubleshooting](advanced/troubleshooting.md) first

---

**Last Updated**: 2025-11-15
**Documentation Version**: 2.0 (Reorganized)
