# Configuration Documentation

This directory contains documentation for configuring MCP Vector Search projects and environments.

## 📋 Contents

*This directory is currently being organized. Configuration documentation will be consolidated here.*

## 🎯 Configuration Topics

### Project Configuration
- **Project Settings** - `.mcp-vector-search/config.json` configuration
- **File Extensions** - Supported file types and language detection
- **Embedding Models** - Model selection and configuration
- **Indexing Behavior** - Skip patterns, gitignore handling

### Environment Configuration
- **Environment Variables** - Runtime configuration options
- **MCP Integration** - Platform-specific configuration
- **Performance Tuning** - Connection pooling, caching settings

### Advanced Configuration
- **Custom Parsers** - Adding new language support
- **Search Tuning** - Similarity thresholds, ranking algorithms
- **File Watching** - Auto-reindexing configuration

## 🔗 Related Documentation

- **[Getting Started - Configuration](../getting-started/configuration.md)** - Basic configuration guide
- **[CLI Usage](../guides/cli-usage.md)** - Configuration via CLI commands
- **[Reference - Configuration Options](../reference/configuration-options.md)** - Complete reference

---

**Note**: This directory is part of the documentation reorganization. Content will be moved here from other locations to create a centralized configuration reference.

**Last Updated**: December 2025
