# Generated by "invoke backend.generate", do not edit directly

from __future__ import annotations

from typing import Any

from pydantic import Field

from infrahub.core.constants import AllowOverrideType, BranchSupportType, HashableModelState
from infrahub.core.models import HashableModel
from infrahub.core.schema.attribute_parameters import (
    AttributeParameters,
    NumberAttributeParameters,
    NumberPoolParameters,
    TextAttributeParameters,
)
from infrahub.core.schema.computed_attribute import ComputedAttribute  # noqa: TC001
from infrahub.core.schema.dropdown import DropdownChoice  # noqa: TC001


class GeneratedAttributeSchema(HashableModel):
    id: str | None = Field(
        default=None, description="The ID of the attribute", json_schema_extra={"update": "not_applicable"}
    )
    name: str = Field(
        ...,
        description="Attribute name, must be unique within a model and must be all lowercase.",
        pattern=r"^[a-z0-9\_]+$",
        min_length=3,
        max_length=32,
        json_schema_extra={"update": "migration_required"},
    )
    kind: str = Field(
        ..., description="Defines the type of the attribute.", json_schema_extra={"update": "migration_required"}
    )
    enum: list | None = Field(
        default=None,
        description="Define a list of valid values for the attribute.",
        json_schema_extra={"update": "validate_constraint"},
    )
    computed_attribute: ComputedAttribute | None = Field(
        default=None,
        description="Defines how the value of this attribute will be populated.",
        json_schema_extra={"update": "allowed"},
    )
    choices: list[DropdownChoice] | None = Field(
        default=None,
        description="Define a list of valid choices for a dropdown attribute.",
        json_schema_extra={"update": "validate_constraint"},
    )
    regex: str | None = Field(
        default=None,
        description="Regex uses to limit the characters allowed in for the attributes. (deprecated: please use parameters.regex instead)",
        json_schema_extra={"update": "validate_constraint"},
    )
    max_length: int | None = Field(
        default=None,
        description="Set a maximum number of characters allowed for a given attribute. (deprecated: please use parameters.max_length instead)",
        json_schema_extra={"update": "validate_constraint"},
    )
    min_length: int | None = Field(
        default=None,
        description="Set a minimum number of characters allowed for a given attribute. (deprecated: please use parameters.min_length instead)",
        json_schema_extra={"update": "validate_constraint"},
    )
    label: str | None = Field(
        default=None,
        description="Human friendly representation of the name. Will be autogenerated if not provided",
        max_length=32,
        json_schema_extra={"update": "allowed"},
    )
    description: str | None = Field(
        default=None,
        description="Short description of the attribute.",
        max_length=128,
        json_schema_extra={"update": "allowed"},
    )
    read_only: bool = Field(
        default=False,
        description="Set the attribute as Read-Only, users won't be able to change its value. Mainly relevant for internal object.",
        json_schema_extra={"update": "migration_required"},
    )
    unique: bool = Field(
        default=False,
        description="Indicate if the value of this attribute must be unique in the database for a given model.",
        json_schema_extra={"update": "validate_constraint"},
    )
    optional: bool = Field(
        default=False,
        description="Indicate if this attribute is mandatory or optional.",
        json_schema_extra={"update": "migration_required"},
    )
    branch: BranchSupportType | None = Field(
        default=None,
        description="Type of branch support for the attribute, if not defined it will be inherited from the node.",
        json_schema_extra={"update": "not_supported"},
    )
    order_weight: int | None = Field(
        default=None,
        description="Number used to order the attribute in the frontend (table and view). Lowest value will be ordered first.",
        json_schema_extra={"update": "allowed"},
    )
    default_value: Any | None = Field(
        default=None, description="Default value of the attribute.", json_schema_extra={"update": "allowed"}
    )
    inherited: bool = Field(
        default=False,
        description="Internal value to indicate if the attribute was inherited from a Generic node.",
        json_schema_extra={"update": "not_applicable"},
    )
    state: HashableModelState = Field(
        default=HashableModelState.PRESENT,
        description="Expected state of the attribute after loading the schema",
        json_schema_extra={"update": "not_applicable"},
    )
    allow_override: AllowOverrideType = Field(
        default=AllowOverrideType.ANY,
        description="Type of allowed override for the attribute.",
        json_schema_extra={"update": "allowed"},
    )
    parameters: AttributeParameters | TextAttributeParameters | NumberAttributeParameters | NumberPoolParameters = (
        Field(
            default_factory=AttributeParameters,
            description="Extra parameters specific to this kind of attribute",
            json_schema_extra={"update": "validate_constraint"},
        )
    )
    deprecation: str | None = Field(
        default=None,
        description="Mark attribute as deprecated and provide a user-friendly message to display",
        max_length=128,
        json_schema_extra={"update": "allowed"},
    )
