# Generated by Django 3.0.3 on 2020-03-13 15:16

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('currency', '0001_initial'),
        ('country', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccountType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='name account type', max_length=45)),
            ],
            options={
                'db_table': 'accounttype',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='Bank',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='bank name', max_length=45)),
                ('is_active', models.BooleanField(default=True)),
                ('account_types', models.ManyToManyField(to='bank.AccountType')),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='country.Country')),
            ],
            options={
                'db_table': 'bank',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='BankAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('account_number', models.CharField(blank=True, max_length=45, null=True)),
                ('inter_account_number', models.CharField(blank=True, max_length=45, null=True)),
                ('account_owner_name', models.CharField(blank=True, max_length=200, null=True)),
                ('account_owner_id', models.CharField(blank=True, help_text='Account owner id, could be RUC, VAT, etc', max_length=200, null=True)),
                ('accounttype', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='bank.AccountType')),
                ('bank', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='bank.Bank')),
                ('currency', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='currency.Currency')),
            ],
            options={
                'db_table': 'bankaccount',
                'ordering': ['-created'],
            },
        ),
    ]
