# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from empire_platform_api_public_client.models.user_organisation import UserOrganisation
from empire_platform_api_public_client.models.user_role import UserRole
from empire_platform_api_public_client.models.user_status import UserStatus

class User(BaseModel):
    """
    User
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    organisation: UserOrganisation = Field(...)
    name: StrictStr = Field(...)
    email: constr(strict=True) = Field(...)
    phone_number: constr(strict=True) = Field(..., alias="phoneNumber")
    role: UserRole = Field(...)
    status: UserStatus = Field(...)
    job_title: Optional[StrictStr] = Field(None, alias="jobTitle")
    __properties = ["id", "organisation", "name", "email", "phoneNumber", "role", "status", "jobTitle"]

    # @validator('email')
    def email_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$", value):
            raise ValueError(r"must validate the regular expression /^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$/")
        return value

    # @validator('phone_number')
    def phone_number_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\+\d{10,13}$", value):
            raise ValueError(r"must validate the regular expression /^\+\d{10,13}$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> User:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of organisation
        if self.organisation:
            _dict['organisation'] = self.organisation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> User:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return User.parse_obj(obj)

        _obj = User.parse_obj({
            "id": obj.get("id"),
            "organisation": UserOrganisation.from_dict(obj.get("organisation")) if obj.get("organisation") is not None else None,
            "name": obj.get("name"),
            "email": obj.get("email"),
            "phone_number": obj.get("phoneNumber"),
            "role": obj.get("role"),
            "status": obj.get("status"),
            "job_title": obj.get("jobTitle")
        })
        return _obj

