# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.address import Address
from empire_platform_api_public_client.models.organisation_status import OrganisationStatus
from empire_platform_api_public_client.models.organisation_type import OrganisationType
from empire_platform_api_public_client.models.participant_overview_data_contact_information import ParticipantOverviewDataContactInformation
from empire_platform_api_public_client.models.participant_overview_data_finance_overview import ParticipantOverviewDataFinanceOverview
from empire_platform_api_public_client.models.participant_overview_data_organisation_members import ParticipantOverviewDataOrganisationMembers

class ParticipantOverviewData(BaseModel):
    """
    ParticipantOverviewData
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    name: StrictStr = Field(...)
    type: OrganisationType = Field(...)
    status: OrganisationStatus = Field(...)
    billing_address: Address = Field(..., alias="billingAddress")
    finance_overview: ParticipantOverviewDataFinanceOverview = Field(..., alias="financeOverview")
    organisation_members: ParticipantOverviewDataOrganisationMembers = Field(..., alias="organisationMembers")
    contact_information: ParticipantOverviewDataContactInformation = Field(..., alias="contactInformation")
    __properties = ["id", "name", "type", "status", "billingAddress", "financeOverview", "organisationMembers", "contactInformation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParticipantOverviewData:
        """Create an instance of ParticipantOverviewData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of billing_address
        if self.billing_address:
            _dict['billingAddress'] = self.billing_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of finance_overview
        if self.finance_overview:
            _dict['financeOverview'] = self.finance_overview.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organisation_members
        if self.organisation_members:
            _dict['organisationMembers'] = self.organisation_members.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact_information
        if self.contact_information:
            _dict['contactInformation'] = self.contact_information.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParticipantOverviewData:
        """Create an instance of ParticipantOverviewData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParticipantOverviewData.parse_obj(obj)

        _obj = ParticipantOverviewData.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "billing_address": Address.from_dict(obj.get("billingAddress")) if obj.get("billingAddress") is not None else None,
            "finance_overview": ParticipantOverviewDataFinanceOverview.from_dict(obj.get("financeOverview")) if obj.get("financeOverview") is not None else None,
            "organisation_members": ParticipantOverviewDataOrganisationMembers.from_dict(obj.get("organisationMembers")) if obj.get("organisationMembers") is not None else None,
            "contact_information": ParticipantOverviewDataContactInformation.from_dict(obj.get("contactInformation")) if obj.get("contactInformation") is not None else None
        })
        return _obj

