# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.aggregated_nomination_options_nominee_participants_inner import AggregatedNominationOptionsNomineeParticipantsInner

class OrganisationDocumentUploadedByUser(BaseModel):
    """
    OrganisationDocumentUploadedByUser
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    name: StrictStr = Field(...)
    organisation: AggregatedNominationOptionsNomineeParticipantsInner = Field(...)
    __properties = ["id", "name", "organisation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganisationDocumentUploadedByUser:
        """Create an instance of OrganisationDocumentUploadedByUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of organisation
        if self.organisation:
            _dict['organisation'] = self.organisation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganisationDocumentUploadedByUser:
        """Create an instance of OrganisationDocumentUploadedByUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrganisationDocumentUploadedByUser.parse_obj(obj)

        _obj = OrganisationDocumentUploadedByUser.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "organisation": AggregatedNominationOptionsNomineeParticipantsInner.from_dict(obj.get("organisation")) if obj.get("organisation") is not None else None
        })
        return _obj

