# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from empire_platform_api_public_client.models.organisation_auth_method import OrganisationAuthMethod
from empire_platform_api_public_client.models.organisation_status import OrganisationStatus
from empire_platform_api_public_client.models.organisation_type import OrganisationType

class Organisation(BaseModel):
    """
    Organisation
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    name: StrictStr = Field(...)
    status: OrganisationStatus = Field(...)
    type: OrganisationType = Field(...)
    auth_method: OrganisationAuthMethod = Field(..., alias="authMethod")
    primary_contact_name: Optional[StrictStr] = Field(None, alias="primaryContactName")
    __properties = ["id", "name", "status", "type", "authMethod", "primaryContactName"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Organisation:
        """Create an instance of Organisation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Organisation:
        """Create an instance of Organisation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Organisation.parse_obj(obj)

        _obj = Organisation.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "auth_method": obj.get("authMethod"),
            "primary_contact_name": obj.get("primaryContactName")
        })
        return _obj

