# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, StrictInt, confloat, conint

class LongTermReservePriceStepsInner(BaseModel):
    """
    When Reserve Price enabled, the range of the Offered Capacity must be covered by price resolution steps.  - from: Lower boundary of step in kilowatts, inclusive - to: Upper boundary of step in kilowatts, inclusive 
    """
    var_from: StrictInt = Field(..., alias="from", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    to: StrictInt = Field(..., description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    reserve_price: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="reservePrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    __properties = ["from", "to", "reservePrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LongTermReservePriceStepsInner:
        """Create an instance of LongTermReservePriceStepsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LongTermReservePriceStepsInner:
        """Create an instance of LongTermReservePriceStepsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LongTermReservePriceStepsInner.parse_obj(obj)

        _obj = LongTermReservePriceStepsInner.parse_obj({
            "var_from": obj.get("from"),
            "to": obj.get("to"),
            "reserve_price": obj.get("reservePrice")
        })
        return _obj

