# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.long_term_reserve_price_steps_inner import LongTermReservePriceStepsInner
from empire_platform_api_public_client.models.reserve_price_publish_type import ReservePricePublishType

class LongTermReservePrice(BaseModel):
    """
    Specifies Reserve Price for a Long Term auction
    """
    steps: conlist(LongTermReservePriceStepsInner) = Field(...)
    publish: ReservePricePublishType = Field(...)
    __properties = ["steps", "publish"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LongTermReservePrice:
        """Create an instance of LongTermReservePrice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LongTermReservePrice:
        """Create an instance of LongTermReservePrice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LongTermReservePrice.parse_obj(obj)

        _obj = LongTermReservePrice.parse_obj({
            "steps": [LongTermReservePriceStepsInner.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "publish": obj.get("publish")
        })
        return _obj

